//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Text.RegularExpressions;

namespace FrameworkLibraries
{
    public class RegexMain
	{
        public static void Main(String[] args)
		{
            Regex emailregex = new Regex("(?<user>[^@]+)@(?<host>.+)");
            string s = "imie.nazwisko@mojafirma.com";

            if ( args.Length > 0 )
			{
                s = args[0];
            }

            Match m = emailregex.Match(s);

            if ( m.Success )
			{
                Console.WriteLine("Uytkownik: " + m.Groups["user"].Value);
                Console.WriteLine("Host: " + m.Groups["host"].Value);
            }
			else
			{
                Console.WriteLine(s + " nie jest poprawnym adresem emailowym");
            }
        }
    }
}